/*
 * Decompiled with CFR 0.152.
 */
package de.aluepke.tools.db.model;

import de.aluepke.tools.db.model.DbModel;
import de.aluepke.util.StringUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Map;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;

public class DbModelGenerator {
    public void generate(DbModel model, Map typeMap, String templateName, OutputStream output) throws IOException {
        VelocityEngine ve = new VelocityEngine();
        ve.setProperty("resource.loader", (Object)"classpath");
        ve.setProperty("classpath.resource.loader.class", (Object)ClasspathResourceLoader.class.getName());
        ve.init();
        VelocityContext context = new VelocityContext();
        context.put("model", (Object)model);
        context.put("typeMap", (Object)typeMap);
        context.put("stringUtil", (Object)new StringUtil());
        Template template = ve.getTemplate(templateName, "UTF-8");
        OutputStreamWriter writer = new OutputStreamWriter(output);
        template.merge((Context)context, (Writer)writer);
        writer.flush();
        writer.close();
    }

    public void generate(DbModel model, String entityName, Map typeMap, String templateName, OutputStream output) throws IOException {
        VelocityEngine ve = new VelocityEngine();
        ve.setProperty("resource.loader", (Object)"classpath");
        ve.setProperty("classpath.resource.loader.class", (Object)ClasspathResourceLoader.class.getName());
        ve.init();
        VelocityContext context = new VelocityContext();
        context.put("entity", (Object)model.getEntity(entityName));
        context.put("model", (Object)model);
        context.put("typeMap", (Object)typeMap);
        context.put("stringUtil", (Object)new StringUtil());
        Template template = ve.getTemplate(templateName, "UTF-8");
        OutputStreamWriter writer = new OutputStreamWriter(output);
        template.merge((Context)context, (Writer)writer);
        writer.flush();
    }
}

