/*
 * Decompiled with CFR 0.152.
 */
package de.aluepke.tools.db.model;

import de.aluepke.tools.db.model.DbModel;
import de.aluepke.tools.db.model.Entity;
import de.aluepke.tools.db.model.Property;
import de.aluepke.tools.db.model.Relationship;
import java.util.ArrayList;
import java.util.List;

public class DbModelBuilder {
    private List<Entity> entities = new ArrayList<Entity>();
    private List<Relationship> relationships = new ArrayList<Relationship>();
    private Entity currentEntity;

    public DbModelBuilder entity(String name, String shortName) {
        this.currentEntity = new Entity(name, shortName);
        this.entities.add(this.currentEntity);
        return this;
    }

    public DbModelBuilder property(String name, String type) {
        Property prop = new Property(name, type);
        this.currentEntity.addProperty(prop);
        return this;
    }

    public DbModelBuilder entity(String name) {
        return this.entity(name, "");
    }

    public DbModelBuilder relationship(String referencingEntityName, String referencedEntityName, String propertyName, String referencingCardinality, String referencedCardinality) {
        Entity referencingEntity = this.getEntity(referencingEntityName);
        Entity referencedEntity = this.getEntity(referencedEntityName);
        Relationship rel = new Relationship(referencingEntity, referencedEntity, propertyName, referencingCardinality, referencedCardinality);
        this.relationships.add(rel);
        return this;
    }

    private Entity getEntity(String name) {
        for (Entity entity : this.entities) {
            if (!entity.getName().equals(name)) continue;
            return entity;
        }
        throw new IllegalStateException("Entity >" + name + "< unknown! Known are:" + this.entities);
    }

    public DbModel build() {
        DbModel model = new DbModel();
        model.setEntites(this.entities);
        model.setRelationships(this.relationships);
        return model;
    }

    public DbModelBuilder fk1(String propertyName, String otherEntityName) {
        this.relationship(this.currentEntity.getName(), otherEntityName, propertyName, "0N", "1");
        return this;
    }
}

