/*
 * Decompiled with CFR 0.152.
 */
package de.aluepke.tools.db.model;

import de.aluepke.tools.db.model.Entity;
import de.aluepke.tools.db.model.Property;
import de.aluepke.tools.db.model.Relationship;
import java.util.ArrayList;
import java.util.List;

public class DbModel {
    private List<Entity> entities = new ArrayList<Entity>();
    private List<Relationship> relationships = new ArrayList<Relationship>();

    public List<Entity> getEntities() {
        return this.entities;
    }

    public List<Relationship> getRelationships() {
        return this.relationships;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (Entity entity : this.entities) {
            sb.append("\n" + entity.getName());
            for (Property property : entity.getProperties()) {
                sb.append("\n  " + property.toString());
            }
            for (Relationship relationship : this.getRelationshipsForEntity(entity.getName())) {
                sb.append("\n  " + relationship.getReferencingPropertyName() + " " + relationship.getReferencingCardinality() + " --> " + relationship.getReferencedCardinality() + " " + relationship.getReferencedEntity().getName());
            }
        }
        return sb.toString();
    }

    private List<Relationship> getRelationshipsForEntity(String name) {
        ArrayList<Relationship> rel = new ArrayList<Relationship>();
        for (Relationship relationship : this.relationships) {
            if (!relationship.getReferencingEntity().getName().equals(name)) continue;
            rel.add(relationship);
        }
        return rel;
    }

    protected void setEntites(List<Entity> entities2) {
        this.entities = entities2;
    }

    protected void setRelationships(List<Relationship> relationships2) {
        this.relationships = relationships2;
    }

    public Entity getEntity(String entityName) {
        for (Entity entity : this.entities) {
            if (!entity.getName().equals(entityName)) continue;
            return entity;
        }
        throw new IllegalArgumentException("Unknown entity >" + entityName + "<. Known entities:" + this.entities);
    }
}

