package de.aluepke.util;

import org.apache.commons.lang3.StringUtils;

import com.google.common.base.CaseFormat;

/**
 * String utils.
 */
public class StringUtil {

    public static final String convertUnderscoreToUpperCamelCase(String string) {
       return CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, string); 
    }
    
    public static final String capitalize(String string) {
        return StringUtils.capitalize(string);
    }
    
    public static final String uncapitalize(String string) {
        return StringUtils.uncapitalize(string);
    }

    public static String convertUnderscoreToLowerCamelCase(String string) {
        return CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, string);
    }

    public static String convertCamelCaseToUpperUnderscore(String string) {
        return CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, string);
    }

    public static String convertCamelCaseToLowerUnderscore(String string) {
        return CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, string);
    }
}
