package de.aluepke.tools.db.model;

/**
 * Relationship between entities.
 */
public class Relationship {

	private Entity referencingEntity;
	//private String cardinality1;
	private Entity referencedEntity;
	private String referencingPropertyName;
	private String referencingCardinality;
	private String referencedCardinality;
	
	public Relationship(Entity referencingEntity, Entity referencedEntity, String propertyName
			, String referencingCardinality, String referencedCardinality) {
		this.referencingEntity = referencingEntity;
		//this.cardinality1 = sourceCardinality;
		this.referencedEntity = referencedEntity;
		this.referencingCardinality = referencingCardinality;
		this.referencedCardinality = referencedCardinality;
		this.referencingPropertyName = propertyName;
	}
	
	public Relationship(Entity referencingEntity, Entity referencedEntity
	        , String propertyName, String cardinality) {
		this(referencingEntity, referencedEntity, propertyName, cardinality, "");
	}

	public Entity getReferencingEntity() {
		return referencingEntity;
	}
	
	public Entity getReferencedEntity() {
		return referencedEntity;
	}
	
	public String getReferencingCardinality() {
		return referencingCardinality;
	}
	
	public String getReferencedCardinality() {
		return referencedCardinality;
	}

	public String getReferencingPropertyName() {
		return referencingPropertyName;
	}

	@Override
	public String toString() {
		return referencedEntity.getName()
		        + " " + referencedCardinality
				+ " -- " + referencingCardinality
				+ " " + referencingEntity.getName() + "." + referencingPropertyName;
	}
}
