package de.aluepke.tools.db.model;

import de.aluepke.util.StringUtil;

/**
 * Column of table/property of entity.
 */
public class Property {

    private String name;
    private String type;
    
    public Property(String name1, String type1) {
        this.name = name1;
        this.type = type1;
    }
    public String getName() {
        return name;
    }
    public String getType() {
        return type;
    }
    @Override
    public String toString() {
        return name + "  " + type;
    }
    
    public String getUpperCamelCaseName() {
        return StringUtil.convertUnderscoreToUpperCamelCase(name);
    }
    public String getLowerCamelCaseName() {
        return StringUtil.convertUnderscoreToLowerCamelCase(name);
    }
    public String getUpperUnderscoreName() {
        return StringUtil.convertCamelCaseToUpperUnderscore(name);
    }
    public String getLowerUnderscoreName() {
        return StringUtil.convertCamelCaseToLowerUnderscore(name);
    }
}
