package de.aluepke.tools.db.model;

import java.util.ArrayList;
import java.util.List;

import de.aluepke.util.StringUtil;

/**
 * Entity/Table.
 */
public class Entity {
    /** name of table/entity. */
    private String name = "";
    /** shortName (used e.g. in constraints). */
    private String shortName = "";
    /** list of properties. */
    private List<Property> properties = new ArrayList<Property>();

    /**
     * constructor.
     * @param name1 - entity name
     * @param shortName1 - short name
     */
    public Entity(String name1, String shortName1) {
        this.name = name1;
        this.shortName = shortName1;
    }
    public void addProperty(Property prop) {
        this.properties.add(prop);
    }
    public String getName() {
        return name;
    }
    public List<Property> getProperties() {
        return this.properties;
    }
    public String getShortName() {
        return shortName;
    }
    @Override
    public String toString() {
        return name;
    }
    
    public String getUpperCamelName() {
        return StringUtil.convertUnderscoreToUpperCamelCase(name);
    }
    public String getLowerCamelName() {
        return StringUtil.convertUnderscoreToLowerCamelCase(name);
    }
    public String getUpperUnderscoreName() {
        return StringUtil.convertCamelCaseToUpperUnderscore(name);
    }
    public String getLowerUnderscoreName() {
        return StringUtil.convertCamelCaseToLowerUnderscore(name);
    }
}
