package de.aluepke.tools.db.model;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Map;

import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.runtime.RuntimeConstants;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;

import de.aluepke.util.StringUtil;

/**
 * code generator.
 */
public class DbModelGenerator {

    public void generate(DbModel model, Map typeMap, String templateName, OutputStream output) throws IOException {
		VelocityEngine ve = new VelocityEngine();
		ve.setProperty(RuntimeConstants.RESOURCE_LOADER, "classpath"); 
		ve.setProperty("classpath.resource.loader.class", ClasspathResourceLoader.class.getName());
		ve.init();
		
		VelocityContext context = new VelocityContext();
		context.put("model", model);
		context.put("typeMap", typeMap);
		context.put("stringUtil", new StringUtil());
		Template template = ve.getTemplate(templateName, "UTF-8");

		OutputStreamWriter writer = new OutputStreamWriter(output);
		template.merge(context, writer);
		writer.flush();
		writer.close();
	}
    
    public void generate(DbModel model, String entityName, Map typeMap, String templateName
            , OutputStream output) throws IOException {
        VelocityEngine ve = new VelocityEngine();
        ve.setProperty(RuntimeConstants.RESOURCE_LOADER, "classpath"); 
        ve.setProperty("classpath.resource.loader.class", ClasspathResourceLoader.class.getName());
        ve.init();
        
        VelocityContext context = new VelocityContext();
        context.put("entity", model.getEntity(entityName));
        context.put("model", model);
        context.put("typeMap", typeMap);
        context.put("stringUtil", new StringUtil());
        Template template = ve.getTemplate(templateName, "UTF-8");

        OutputStreamWriter writer = new OutputStreamWriter(output);
        template.merge(context, writer);
        writer.flush();
    }
}
