package de.aluepke.tools.db.model;

import java.util.ArrayList;
import java.util.List;

/**
 * Model Builder.
 */
public class DbModelBuilder {

	private List<Entity> entities = new ArrayList<Entity>();
	private List<Relationship> relationships = new ArrayList<Relationship>();
	
	private Entity currentEntity;
	
	public DbModelBuilder entity(String name, String shortName) {
		currentEntity = new Entity(name, shortName);
		entities.add(currentEntity);
		return this;
	}
	
	public DbModelBuilder property(String name, String type) {
		Property prop = new Property(name, type);
		currentEntity.addProperty(prop);
		return this;
	}

	public DbModelBuilder entity(String name) {
		return entity(name, "");
	}

	public DbModelBuilder relationship(String referencingEntityName, String referencedEntityName
	        , String propertyName, String referencingCardinality, String referencedCardinality) {
		Entity referencingEntity = getEntity(referencingEntityName);
		Entity referencedEntity = getEntity(referencedEntityName);
		Relationship rel = new Relationship(referencingEntity, referencedEntity
		        , propertyName, referencingCardinality, referencedCardinality);
		relationships.add(rel);
		return this;
	}

	private Entity getEntity(String name) {
		for (Entity entity : this.entities) {
			if (entity.getName().equals(name)) {
				return entity;
			}
		}
		throw new IllegalStateException("Entity >" + name + "< unknown! Known are:" + entities);
	}

	public DbModel build() {
		DbModel model = new DbModel();
		model.setEntites(entities);
		model.setRelationships(relationships);
		return model;
	}

	public DbModelBuilder fk1(String propertyName, String otherEntityName) {
		relationship(currentEntity.getName(), otherEntityName, propertyName, "0N", "1");
		return this;
	}
	
}
