/*
 * Decompiled with CFR 0.152.
 */
package de.aluepke.util.net;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLEncoder;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.log4j.Logger;

public class HttpsRequestUtil {
    private static final Logger LOG = Logger.getLogger(HttpsRequestUtil.class);

    public static void ignoreCertificate() {
        LOG.warn((Object)"Disabeling all Server authentication -> Ignoring all SSL certificates");
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        try {
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        }
        catch (GeneralSecurityException e) {
            e.printStackTrace();
        }
    }

    public static String sendHttpsRequest(String url, Map<String, String> parameters) throws IOException {
        String inputLine;
        LOG.info((Object)("Sending Https request to url >" + url + "< parameters >" + parameters + "<"));
        String httpsURL = url;
        StringBuffer query = new StringBuffer();
        for (Map.Entry<String, String> keyValue : parameters.entrySet()) {
            query.append(URLEncoder.encode(keyValue.getKey(), "UTF-8"));
            query.append("=");
            query.append(URLEncoder.encode(keyValue.getValue(), "UTF-8"));
            query.append("&");
        }
        String queryStr = query.toString().substring(0, query.length() - 1);
        HttpsRequestUtil.ignoreCertificate();
        URL myurl = new URL(httpsURL);
        HttpsURLConnection con = (HttpsURLConnection)myurl.openConnection();
        con.setRequestMethod("POST");
        con.setRequestProperty("Content-length", String.valueOf(query.length()));
        con.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        con.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 5.0;Windows98;DigExt)");
        con.setDoOutput(true);
        con.setDoInput(true);
        LOG.debug((Object)("post parameter query string:" + queryStr));
        DataOutputStream output = new DataOutputStream(con.getOutputStream());
        output.writeBytes(queryStr);
        output.flush();
        output.close();
        int responseCode = con.getResponseCode();
        LOG.debug((Object)("Response Code : " + responseCode));
        BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
        StringBuffer response = new StringBuffer();
        while ((inputLine = in.readLine()) != null) {
            response.append("\n" + inputLine);
        }
        in.close();
        return response.toString();
    }
}

