/*
 * Decompiled with CFR 0.152.
 */
package de.aluepke.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class CollectionUtil {
    public static final String join(List<?> list, String seperator) {
        return StringUtils.join(list, (String)seperator);
    }

    public static Map<String, String> map(String ... str) {
        assert (str.length % 2 == 0) : "Must be even number of arguments";
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < str.length; i += 2) {
            map.put(str[i].toString(), str[i + 1].toString());
        }
        return map;
    }

    public static Map<Object, Object> omap(Object ... objs) {
        assert (objs.length % 2 == 0) : "Must be even number of arguments";
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        for (int i = 0; i < objs.length; i += 2) {
            map.put(objs[i], objs[i + 1]);
        }
        return map;
    }

    public static String join(Object[] values, String glue) {
        return CollectionUtil.join(values, glue, "", "");
    }

    public static String join(Object[] values, String glue, String itemPrefix, String itemPostfix) {
        int length = values.length;
        if (length == 0) {
            return "";
        }
        StringBuilder out = new StringBuilder();
        out.append(itemPrefix).append(values[0]).append(itemPostfix);
        for (int x = 1; x < length; ++x) {
            out.append(glue).append(itemPrefix).append(values[x]).append(itemPostfix);
        }
        return out.toString();
    }

    public static Set set(Object ... objs) {
        HashSet<Object> set = new HashSet<Object>();
        for (Object object : objs) {
            set.add(object);
        }
        return set;
    }

    public static final Set<String> filterStartWith(Collection<String> strings, String prefix) {
        HashSet<String> result = new HashSet<String>();
        for (String key : strings) {
            if (!key.startsWith(prefix)) continue;
            result.add(key);
        }
        return result;
    }
}

