/*
 * Decompiled with CFR 0.152.
 */
package de.aluepke.tools.db.model;

import de.aluepke.tools.db.model.Column;
import de.aluepke.util.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Table {
    private String name = "";
    private String shortName = "";
    private List<Column> properties = new ArrayList<Column>();
    private List<List<String>> uniqueKeys = new ArrayList<List<String>>();

    public Table(String name1, String shortName1) {
        this.name = name1;
        this.shortName = shortName1;
    }

    public void addColumn(Column prop) {
        this.properties.add(prop);
    }

    public String getName() {
        return this.name;
    }

    public List<Column> getProperties() {
        return this.properties;
    }

    public String getShortName() {
        return this.shortName;
    }

    public String toString() {
        return this.name;
    }

    public String getUpperCamelName() {
        return StringUtil.convertUnderscoreToUpperCamelCase(this.name);
    }

    public String getLowerCamelName() {
        return StringUtil.convertUnderscoreToLowerCamelCase(this.name);
    }

    public String getUpperUnderscoreName() {
        return StringUtil.convertCamelCaseToUpperUnderscore(this.name);
    }

    public String getLowerUnderscoreName() {
        return StringUtil.convertCamelCaseToLowerUnderscore(this.name);
    }

    public void addUniqueKey(String ... columns) {
        List<String> columnList = Arrays.asList(columns);
        this.uniqueKeys.add(columnList);
    }

    public List<List<String>> getUniqueKeys() {
        return this.uniqueKeys;
    }
}

