/*
 * Decompiled with CFR 0.152.
 */
package de.aluepke.tools.db.model;

import de.aluepke.tools.db.model.DbModel;
import de.aluepke.util.CollectionUtil;
import de.aluepke.util.StringUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Map;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;

public class DbModelGenerator {
    public void generateFullModel(DbModel model, Map<String, String> typeMap, String templateName, OutputStream output) throws IOException {
        VelocityEngine ve = this.getEngine();
        VelocityContext context = this.getStandardContext(model, typeMap);
        Template template = ve.getTemplate(templateName, "UTF-8");
        OutputStreamWriter writer = new OutputStreamWriter(output);
        template.merge((Context)context, (Writer)writer);
        writer.flush();
        writer.close();
    }

    private VelocityContext getStandardContext(DbModel model, Map<String, String> typeMap) {
        VelocityContext context = new VelocityContext();
        context.put("model", (Object)model);
        context.put("typeMap", typeMap);
        context.put("stringUtil", (Object)new StringUtil());
        context.put("colUtil", (Object)new CollectionUtil());
        return context;
    }

    public void generateSingleTable(DbModel model, String tableName, Map<String, String> typeMap, String templateName, OutputStream output) throws IOException {
        VelocityEngine ve = this.getEngine();
        VelocityContext context = this.getStandardContext(model, typeMap);
        context.put("table", (Object)model.getTable(tableName));
        Template template = ve.getTemplate(templateName, "UTF-8");
        OutputStreamWriter writer = new OutputStreamWriter(output);
        template.merge((Context)context, (Writer)writer);
        writer.flush();
    }

    public void generateJava(String outputDir, String packageName, String className, DbModel model, String tableName, Map<String, String> typeMap, String templateName) throws IOException {
        VelocityEngine ve = this.getEngine();
        VelocityContext context = this.getStandardContext(model, typeMap);
        context.put("package", (Object)packageName);
        context.put("class", (Object)className);
        context.put("table", (Object)model.getTable(tableName));
        Template template = ve.getTemplate(templateName, "UTF-8");
        String packageFolderName = packageName.replaceAll("\\.", "/");
        File outputFile = new File(outputDir + "/" + packageFolderName + "/" + className + ".java");
        if (outputFile.exists()) {
            outputFile.delete();
        }
        outputFile.getParentFile().mkdirs();
        FileWriter writer = new FileWriter(outputFile);
        template.merge((Context)context, (Writer)writer);
        ((Writer)writer).flush();
    }

    private VelocityEngine getEngine() {
        VelocityEngine ve = new VelocityEngine();
        ve.setProperty("resource.loader", (Object)"classpath");
        ve.setProperty("classpath.resource.loader.class", (Object)ClasspathResourceLoader.class.getName());
        ve.init();
        return ve;
    }
}

