/*
 * Decompiled with CFR 0.152.
 */
package de.aluepke.tools.db.model;

import de.aluepke.tools.db.model.Column;
import de.aluepke.tools.db.model.DbModel;
import de.aluepke.tools.db.model.Relationship;
import de.aluepke.tools.db.model.Table;
import java.util.ArrayList;
import java.util.List;

public class DbModelBuilder {
    private List<Table> tables = new ArrayList<Table>();
    private List<Relationship> relationships = new ArrayList<Relationship>();
    private Table currentTable;

    public DbModelBuilder table(String name, String shortName) {
        this.currentTable = new Table(name, shortName);
        this.tables.add(this.currentTable);
        return this;
    }

    public DbModelBuilder column(String name, String type) {
        Column prop = new Column(name, type);
        this.currentTable.addColumn(prop);
        return this;
    }

    public DbModelBuilder table(String name) {
        return this.table(name, "");
    }

    public DbModelBuilder relationship(String referencingTableName, String referencedTableName, String columnName, String referencingCardinality, String referencedCardinality) {
        Table referencingTable = this.getTable(referencingTableName);
        Table referencedTable = this.getTable(referencedTableName);
        Relationship rel = new Relationship(referencingTable, referencedTable, columnName, referencingCardinality, referencedCardinality);
        this.relationships.add(rel);
        return this;
    }

    private Table getTable(String name) {
        for (Table table : this.tables) {
            if (!table.getName().equals(name)) continue;
            return table;
        }
        throw new IllegalStateException("Table >" + name + "< unknown! Known are:" + this.tables);
    }

    public DbModel build() {
        DbModel model = new DbModel();
        model.setTables(this.tables);
        model.setRelationships(this.relationships);
        return model;
    }

    public DbModelBuilder fk1(String columnName, String otherTableName) {
        this.relationship(this.currentTable.getName(), otherTableName, columnName, "0N", "1");
        return this;
    }

    public DbModelBuilder unique(String ... columns) {
        this.currentTable.addUniqueKey(columns);
        return this;
    }
}

