/*
 * Decompiled with CFR 0.152.
 */
package de.aluepke.tools.db.model;

import de.aluepke.tools.db.model.Column;
import de.aluepke.tools.db.model.Relationship;
import de.aluepke.tools.db.model.Table;
import java.util.ArrayList;
import java.util.List;

public class DbModel {
    private List<Table> tables = new ArrayList<Table>();
    private List<Relationship> relationships = new ArrayList<Relationship>();

    public List<Table> getTables() {
        return this.tables;
    }

    public List<Relationship> getRelationships() {
        return this.relationships;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (Table table : this.tables) {
            sb.append("\n" + table.getName());
            for (Column property : table.getProperties()) {
                sb.append("\n  " + property.toString());
            }
            for (Relationship relationship : this.getRelationshipsForTable(table.getName())) {
                sb.append("\n  " + relationship.getReferencingColumnName() + " " + relationship.getReferencingCardinality() + " --> " + relationship.getReferencedCardinality() + " " + relationship.getReferencedTable().getName());
            }
        }
        return sb.toString();
    }

    private List<Relationship> getRelationshipsForTable(String name) {
        ArrayList<Relationship> rel = new ArrayList<Relationship>();
        for (Relationship relationship : this.relationships) {
            if (!relationship.getReferencingTable().getName().equals(name)) continue;
            rel.add(relationship);
        }
        return rel;
    }

    protected void setTables(List<Table> tables) {
        this.tables = tables;
    }

    protected void setRelationships(List<Relationship> relationships2) {
        this.relationships = relationships2;
    }

    public Table getTable(String tableName) {
        for (Table table : this.tables) {
            if (!table.getName().equals(tableName)) continue;
            return table;
        }
        throw new IllegalArgumentException("Unknown table >" + tableName + "<. Known tables:" + this.tables);
    }
}

