package de.aluepke.util.template;

import org.apache.commons.lang3.StringUtils;

/**
 * String utils.
 */
public class TemplateStringUtil {

    public static final String toLC(String s) {
        if (s != null) {
            return s.toLowerCase();
        } else {
            return null;
        }
    }
    
    public static final String toUC(String s) {
        if (s != null) {
            return s.toUpperCase();
        } else {
            return null;
        }
    }
    
    public static final String toUCC(String s) {
        return toCC(s, true);
    }
    
    public static final String toLCC(String s) {
        return toCC(s, false);
    }
    
    private static final String toCC(String s, boolean firstLetterUpperCase) {
        StringBuffer sb = new StringBuffer();
        char previousCh = ' ';
        boolean isFirst = true;
        for (char ch : s.toCharArray()){
            if (ch == '_') {
                // skip
            } else if (isFirst) {
                if (firstLetterUpperCase) {
                    sb.append(Character.toUpperCase(ch));
                } else {
                    sb.append(Character.toLowerCase(ch));
                }
                isFirst = false;
            } else {
                if (previousCh == '_') {
                    sb.append(Character.toUpperCase(ch));
                } else {
                    sb.append(ch);
                }
            }
            previousCh = ch;
        }
        return sb.toString();
    }

    public static final String toUUS(String s) {
        return toUS(s, true);
    }
    
    public static final String toLUS(String s) {
        return toUS(s, false);
    }
    
    private static final String toUS(String s, boolean allUppercase) {
        StringBuffer sb = new StringBuffer();
        char previousCh = ' ';
        for (char ch : s.toCharArray()){
            if (Character.isUpperCase(ch) && Character.isLowerCase(previousCh)) {
                sb.append('_');
            }
            if (allUppercase) {
                sb.append(Character.toUpperCase(ch));
            } else {
                sb.append(Character.toLowerCase(ch));
            }
            previousCh = ch;
        }
        return sb.toString();
    }
    
    public static final String cap(String string) {
        return StringUtils.capitalize(string);
    }
    
    public static final String uncap(String string) {
        return StringUtils.uncapitalize(string);
    }
}
