package de.aluepke.util.net.rest;

import java.util.HashMap;

import de.aluepke.util.SignatureUtil;

/**
 * HttpsRestRequest.
 */
public class SignedHttpsRestRequest {
    
    private HashMap<String, String> parametersToSend;

    public SignedHttpsRestRequest(String authKey, String parameter) {
        
        String timestamp = "" + System.currentTimeMillis();
        String hash = SignatureUtil.generateHmacSha1(parameter + timestamp, authKey);
        
        parametersToSend = new HashMap<String, String>();
        parametersToSend.put("p", parameter);
        parametersToSend.put("t", timestamp);
        parametersToSend.put("h", hash);
    }

    @SuppressWarnings("unchecked")
    public HashMap<String, String> getParametersToSend() {
        return (HashMap<String, String>) parametersToSend.clone();
    }
    
    
}
