package de.aluepke.tools.db.model;

import java.util.ArrayList;
import java.util.List;

/**
 * Model.
 */
public class DbModel {

	private List<Entity> entities = new ArrayList<Entity>();
	private List<Relationship> relationships = new ArrayList<Relationship>();
	
	public List<Entity> getEntities() {
		return entities;
	}
	
    public List<Relationship> getRelationships() {
        return relationships;
    }

	@Override
	public String toString() {
		StringBuffer sb = new StringBuffer();
		for (Entity entity : entities) {
			sb.append("\n" + entity.getName());
			
			for (Property property : entity.getProperties()) {
				sb.append("\n  " + property.toString());
			}
			
			for (Relationship relationship : getRelationshipsForEntity(entity.getName())) {
				sb.append("\n  " + relationship.getReferencingPropertyName()
						+ " " + relationship.getReferencingCardinality()
						+ " --> " + relationship.getReferencedCardinality()
						+ " " + relationship.getReferencedEntity().getName());
			}
		}
		return sb.toString();
	}

	private List<Relationship> getRelationshipsForEntity(String name) {
		List<Relationship> rel = new ArrayList<Relationship>();
		for (Relationship relationship : relationships) {
			if (relationship.getReferencingEntity().getName().equals(name)) {
				rel.add(relationship);
			}
			//if (relationship.getReferencedEntity().getName().equals(name)) {
			//	rel.add(relationship);
			//}
		}
		return rel;
	}

    protected void setEntites(List<Entity> entities2) {
        this.entities = entities2;
    }

    protected void setRelationships(List<Relationship> relationships2) {
        this.relationships = relationships2;
    }

    public Entity getEntity(String entityName) {
        for (Entity entity : this.entities) {
            if (entity.getName().equals(entityName)) {
                return entity;
            }
        }
        throw new IllegalArgumentException("Unknown entity >" + entityName + "<. Known entities:" + entities);
    }
}
